Attribute VB_Name = "SpeechFunctions"
Option Explicit

' Modul: Speechfunctions
' Beschreibung: Das Modul Speechfunctions erledigt die meiste Arbeit in OSE.
'               Vor allem stellt es Funktionen zur Verfgung, mit denen die wichtigsten Informationen
'               von Outlook-Elementen in einem lesbaren Textstring zusammengefasst werden,
'               der dann ber die Form SpeechForm vorgelesen werden knnen.
'               Ausserdem befinden sich hier die meisten der OSE-Steuerfunktionen, mit denen
'               OSE aufgerufen werden kann.


' SpeakHidden: Liest den ber Text bergebenen String ohne Anzeige des Wiedergabefensters vor
Public Sub SpeakHidden(Text As String)
    Load SpeechForm
    With SpeechForm
        .Text = Text
        .StartHiddenSpeaking
    End With
    Unload SpeechForm
End Sub

' ItemSummary: liefert eine bersicht ber ungelesene Nachrichten, aktuelle Termine und Aufgaben
Public Function ItemSummary()
    ItemSummary = "Sie haben heute " + GetUnreadMailText + ", " _
        + GetAppointmentsText + " und " + GetIncompleteTasksText + "."
End Function

' GetIncompleteTasksText: liefert einen Text ber die Anzahl der noch nicht erledigten
'                            und / oder flligen Aufgaben zurck
Public Function GetIncompleteTasksText() As String
    Select Case IncompleteTasks(False)
    Case Is <= 0
        GetIncompleteTasksText = "keine unerledigten Aufgaben"
    Case Is = 1
        If IncompleteTasks(True) >= 1 Then
            GetIncompleteTasksText = "eine unerledigte und fllige Aufgabe"
        Else
            GetIncompleteTasksText = "eine unerledigte Aufgabe"
        End If
    Case Is >= 2
        Select Case IncompleteTasks(True)
        Case Is >= IncompleteTasks(False)
            GetIncompleteTasksText = CStr(IncompleteTasks(False)) _
                + " unerledigte und fllige Aufgaben"
        Case Is = 0
            GetIncompleteTasksText = CStr(IncompleteTasks(False)) _
                + " unerledigte Aufgaben"
        Case Is = 1
            GetIncompleteTasksText = CStr(IncompleteTasks(False)) _
                + " unerledigte Aufgaben, von denen eine fllig ist"
        Case Else
            GetIncompleteTasksText = CStr(IncompleteTasks(False)) _
                + " unerledigte Aufgaben, von denen " + CStr(IncompleteTasks(True)) _
                + " fllig sind"
        End Select
    End Select
End Function

' GetAppointmentsText: liefert einen Text ber die Anzahl der heute anstehenden Termine zurck
Public Function GetAppointmentsText() As String
    Select Case AppointmentsToday
    Case Is <= 0
        GetAppointmentsText = "keine Termine"
    Case Is = 1
        GetAppointmentsText = "einen Termin"
    Case Is >= 2
        GetAppointmentsText = CStr(AppointmentsToday) + " Termine"
    End Select
End Function

' GetUnreadMailText: liefert einen Text ber die Anzahl der ungelesenen Nachrichten im Posteingang zurck
Public Function GetUnreadMailText() As String
    Select Case UnreadMails
    Case Is <= 0
        GetUnreadMailText = "keine ungelesenen Nachrichten"
    Case Is = 1
        GetUnreadMailText = "eine ungelesene Nachricht"
    Case Is >= 2
        GetUnreadMailText = CStr(UnreadMails) + " ungelesene Nachrichten"
    End Select
End Function

' ShowInfoDialog: Zeigt einen Infodialog mit OSE-Informationen an
Public Sub ShowInfoDialog()
    MsgBox APP_NAME + vbNewLine _
        + "Autor: " + AUTHOR + vbNewLine _
        + "Version: " + VERSION + STATE
End Sub

' ShowOptionDialog: ffnet den Dialog fr die Optionseinstellungen
Public Sub ShowOptionDialog()
    MsgBox "Noch nicht implementiert"
End Sub

' ReadItem: zentrale Funktion zum Vorlesen von Outlook Elementen, die ber Item bergeben werden
Public Sub ReadItem(Item As Object)
    Dim Text As String, Description As String
    
    Select Case Item.Class
    Case olMail, olPost
        Text = GetMailText(Item)
        Description = "Nachricht von " + Item.SenderName
    Case olContact
        Text = GetContactText(Item)
        Description = Item.FullName
    Case olAppointment
        Text = GetAppointmentText(Item)
        Description = "Termin am " + Format(Item.StartDate, "short date")
    End Select
    
    With SpeechForm
        .Text = Text
        .Caption = Description
        .Show
    End With
End Sub

' GetMailText: Liefert den Text zum Vorlesen der per Message bergebenen Nachricht zurck
Public Function GetMailText(Message As MailItem) As String
    Dim Header As String, Body As String
    
    Header = "Nachricht von " + Message.SenderName + ", " + vbNewLine _
        + "erhalten am " + Format(Message.ReceivedTime, "short date") _
        + " um " + Format(Message.ReceivedTime, "Short Time") + ", " + vbNewLine _
        + "betreffend: " + ExpandedSubject(Message.Subject) + "." + vbNewLine + vbNewLine
    If Message.Attachments.Count > 0 Then
        Header = Header + "Die Nachricht enthlt " _
            + IIf(Message.Attachments.Count = 1, "eine angehngte Datei.", _
                CStr(Message.Attachments.Count) + " angehngte Dateien.") + vbNewLine
    End If
    
    If Len(Message.HTMLBody) > 0 Then
        Header = Header + "Die Nachricht enthlt HTML." + vbNewLine
        Body = "Inhalt der Nachricht (nur Text): " + vbNewLine + vbNewLine + Html2Text(Message.HTMLBody)
    Else
        Body = "Inhalt der Nachricht: " + vbNewLine + vbNewLine + Message.Body
    End If
    
    GetMailText = Header + Body
End Function

' ReadActiveItem: Liest das aktuell markierte Element vor (funktioniert nicht bei Mehrfachauswahl)
Public Sub ReadActiveItem()
    If Application.ActiveExplorer.Selection.Count = 1 Then
        ReadItem Application.ActiveExplorer.Selection.Item(1)
    End If
End Sub

' Notify: Hilfsfunktion zum Erzeugen von Benachrichtigungen
Public Sub Notify(Text As String, Caption As String)
    If Settings.NotifyHidden Then
        SpeakHidden Text
    Else
        With SpeechForm
            .Caption = Caption
            .Text = Text
            .CloseAfterSpeaking = Settings.CloseNotifyWindow
            .Show
        End With
    End If
End Sub

' GetContactText: Liefert den Text zum Vorlesen von Informationen ber den per Contact
'                   bergebenen Kontakt zurck
Public Function GetContactText(Constact As ContactItem) As String
    Dim nv As String
    
    nv = Settings.UnknownText
    With Constact
        GetContactText = "Informationen ber " + .FullName + ":" + vbNewLine + vbNewLine _
            + "Vorname: " + IIf(.FirstName = "", nv, .FirstName) + ", " + vbNewLine _
            + "Nachname: " + IIf(.LastName = "", nv, .LastName) + ", " + vbNewLine _
            + "E-Mail Adresse: " + IIf(.Email1Address = "", nv, .Email1Address) + ", " + vbNewLine _
            + "Telefonnummer: " + IIf(.HomeTelephoneNumber = "", nv, .HomeTelephoneNumber) + ", " + vbNewLine _
            + "Anschrift: " + IIf(.MailingAddress = "", nv, .MailingAddress) + ", " + vbNewLine _
            + "Homepage: " + IIf(.PersonalHomePage = "", nv, .PersonalHomePage) + ", " + vbNewLine _
            + "Geburtstag: " + IIf(Year(.Birthday) < 1920 Or Year(.Birthday) > 2500, nv, CStr(.Birthday))
    End With
End Function

' GetAppointmentText: Liefert den Text zum Vorlesen des per Appointment bergebenen Termins zurck
Public Function GetAppointmentText(Appointment As AppointmentItem) As String
    Dim nv As String
    
    nv = Settings.UnknownText
    With Appointment
        If .Start - .End < 1.5 Then
            GetAppointmentText = "Termin am " + Format(.Start, "short date") _
                + IIf(.AllDayEvent, "", " um " + Format(.Start, "short time")) + ": " + vbNewLine
        Else
            GetAppointmentText = "Termin vom " + Format(.Start, "short date") _
                + IIf(.AllDayEvent, "", ", " + Format(.Start, "short time")) _
                + " bis zum " + Format(.End, "short date") _
                + IIf(.AllDayEvent, "", ", " + Format(.End, "short time")) + ": " + vbNewLine
        End If
        GetAppointmentText = GetAppointmentText + "Thema: " + IIf(.Subject = "", nv, .Subject) + ", " + vbNewLine _
            + "Ort: " + IIf(.Location = "", nv, .Location) + ", " + vbNewLine
    End With
End Function

' OSE_Init: Erzeugt beim Outlook-Start eine Begrungsnachricht und liest diese vor
'           Die Begrung besteht aus einer Anrede sowie einer Zusammenfassung ber
'           ungelesene Nachrichten, aktuelle Termine und unerledigte Aufgaben
Public Sub OSE_Init()
    Dim Greeting As String
    
    If Settings.GreetOncePerDay And Int(Settings.LastGreeting) = Int(Date) Then
        Exit Sub
    Else
        Settings.LastGreeting = Date
    End If
    
    With SpeechForm.SpeechControl
        If .GetUserGreeting = "" Then
            Greeting = Settings.AlternateGreeting + ", " + ItemSummary
        Else
            Greeting = .GetUserGreeting + " " + .GetUserName + ", " + ItemSummary
        End If
    End With
    
    If Settings.StartHidden Then
        SpeakHidden Greeting
    Else
        With SpeechForm
            .Caption = IIf(.SpeechControl.GetUserGreeting = "", _
                Settings.AlternateGreeting, .SpeechControl.GetUserGreeting + " " + .SpeechControl.GetUserName)
            .Text = Greeting
            .CloseAfterSpeaking = Settings.CloseStartupWindow
            .Show
        End With
    End If
End Sub

' Notifier: generelle Benachrichtigungsfunktion, die abhngig von der Item-Klasse die
'           Aufrufe an Notify kapselt (momentan nur fr verschickte Mails)
Public Sub Notifier(Item As Object)
    Select Case Item.Class
    Case Is = olMail
        Notify "Nachricht an " + Item.To + " wurde gesendet.", Settings.MailSendNotifyCaption
    End Select
End Sub
