VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} SpeechForm 
   Caption         =   "Sprachausgabe"
   ClientHeight    =   4305
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5415
   OleObjectBlob   =   "SpeechForm.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "SpeechForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim SpeakHidden As Boolean
Dim OldTop As Double
Dim OldLeft As Double
Dim CloseFormAfterSpeaking As Boolean
Dim TextValue As String

Private Sub CloseButton_Click()
    SpeechControl.StopSpeaking
    Unload Me
End Sub

Private Sub InfoButton_Click()
    ShowInfoDialog
End Sub

Private Sub OptionButton_Click()
    ShowOptionDialog
End Sub

Private Sub PauseButton_Click()
    SpeechControl.PauseSpeaking
End Sub

Private Sub PlayButton_Click()
    With SpeechControl
        If .IsPause Then
            .ResumeSpeaking
        Else
            .StartSpeaking
        End If
    End With
End Sub

Private Sub SpeechControl_OnPauseSpeaking(ByVal nReason As Long)
    PlayButton.Enabled = True
    PauseButton.Enabled = False
    StopButton.Enabled = True
End Sub

Private Sub SpeechControl_OnResumeSpeaking(ByVal nReason As Long)
    SpeechControl_OnStartSpeaking nReason
End Sub

Private Sub SpeechControl_OnStartSpeaking(ByVal nReason As Long)
    PlayButton.Enabled = False
    PauseButton.Enabled = True
    StopButton.Enabled = True
End Sub

Private Sub SpeechControl_OnStopSpeaking(ByVal nReason As Long)
    PlayButton.Enabled = True
    PauseButton.Enabled = False
    StopButton.Enabled = False
    If SpeakHidden Then
        SpeakHidden = False
        Me.Hide
        Me.Top = OldTop
        Me.Left = OldLeft
    End If
    If CloseAfterSpeaking Then Unload Me
End Sub

Private Sub StopButton_Click()
    SpeechControl.StopSpeaking
End Sub

Private Sub UserForm_Activate()
    If Not SpeechControl.IsSpeaking Then
        SpeechControl.StartSpeaking
    End If
End Sub

Private Sub UserForm_Initialize()
    CloseFormAfterSpeaking = False
    With SpeechControl
        .SetMouthAnimation 1
        .SetTextColor "silver,TRANSPARENT"
        .SetTextAnimation 0
        .SetTextPosition 100
        .SetTextSize 13
    End With
End Sub

Public Property Get Text() As String
    Text = TextValue
End Property

Public Property Let Text(ByVal vNewValue As String)
    TextValue = vNewValue
    SpeechControl.SetText TextValue
    TextField.Caption = TextValue
End Property

Public Sub Reset()
    SpeechControl.StopSpeaking
    Text = ""
    For Each Button In Me.Controls
        Button.Enabled = True
    Next Button
End Sub

Public Sub StartHiddenSpeaking()
    SpeakHidden = True
    OldTop = Me.Top
    OldLeft = Me.Left
    Me.StartUpPosition = 0
    Me.Top = 10000
    Me.Left = 10000
    Me.Show
    SpeechControl.StartSpeakingImmediate
End Sub

Public Property Get CloseAfterSpeaking() As Boolean
    CloseAfterSpeaking = CloseFormAfterSpeaking
End Property

Public Property Let CloseAfterSpeaking(ByVal vNewValue As Boolean)
    CloseFormAfterSpeaking = vNewValue
End Property
