Attribute VB_Name = "Simplifiers"
Option Explicit

' Modul: Simplifiers
' Beschreibung: Das Modul Simplifiers stellt einige Funktionen zum vereinfachten Zugriff auf
'               diverse Eigenschaften sowie einige allgemein verwendbare Hilfesfunktionen
'               zur Verfgung.

' UnreadMails: liefert die Anzahl der ungelesenen Nachrichten im Posteingang (nur dort)
Public Function UnreadMails()
    UnreadMails = Application.GetNamespace("MAPI").GetDefaultFolder(olFolderInbox).UnReadItemCount
End Function

' AppointmentsToday: liefert die Anzahl der heute stattfindenden Termine (Start <= Heute <= Ende)
Public Function AppointmentsToday()
    Dim CalendarFolder As MAPIFolder
    Dim Appointment As AppointmentItem
    
    Set CalendarFolder = Application.GetNamespace("MAPI").GetDefaultFolder(olFolderCalendar)
    For Each Appointment In CalendarFolder.Items
        If Appointment.Start <= Date And Appointment.End >= Date Then
            AppointmentsToday = AppointmentsToday + 1
        End If
    Next Appointment
End Function

' IncompleteTasks: liefert die Anzahl der noch nicht erledigten Aufgaben. Bei OnlyDue = True werde nur die flligen Aufgaben zurckgeliefert
Public Function IncompleteTasks(OnlyDue As Boolean)
    Dim TaskFolder As MAPIFolder
    Dim Task As TaskItem
    
    Set TaskFolder = Application.GetNamespace("MAPI").GetDefaultFolder(olFolderTasks)
    For Each Task In TaskFolder.Items
        If Int(Task.StartDate) <= Int(Date) And Not Task.Status = olTaskComplete Then
            If OnlyDue Then
                If Int(Task.DueDate) <= Int(Date) Then
                    IncompleteTasks = IncompleteTasks + 1
                End If
            Else
                IncompleteTasks = IncompleteTasks + 1
            End If
        End If
    Next Task
End Function

' ExpandedSubject: Ersetzt in Subject einige gebruchliche Abkrzungen fr Antwort und Weitergeleitet mit
'                   der ausgeschriebenen Version und liefert das Ergebnis zurck
Public Function ExpandedSubject(Subject As String) As String
    Dim Abrevs As Variant, Meanings As Variant
    Dim i As Integer, Pos As Long
    
    Abrevs = Array("AW:", "RE:", "WG:", "FW:", "Fwd:")
    Meanings = Array("Antwort:", "Antwort:", "weitergeleitet:", "weitergeleitet:", "weitergeleitet")
    If UBound(Abrevs) <> UBound(Meanings) Then
        Error 51
    End If
    
    For i = 0 To UBound(Abrevs)
        Pos = 1
        Do Until Pos = 0
            Pos = InStr(Pos, UCase(Subject), Abrevs(i))
            If Pos > 0 Then
                Subject = Left(Subject, Pos - 1) + Meanings(i) + Mid(Subject, Pos + Len(Abrevs(i)))
            End If
        Loop
    Next i
    ExpandedSubject = Subject
End Function

' Html2Text: entfernt aus HtmlString smtliche HTML-Tags (ein Tag ist dabei alles zwischen < und >)
'            und ersetzt einige HTML Escape-Sequenzen (v.a. Umlaute und HTML-Steuerzeichen) und liefert das Ergebnis zurck
Public Function Html2Text(HtmlString As String) As String
    Dim Pos As Long, EndPos As Long, i As Long
    Dim Abrevs As Variant, Meanings As Variant
    
    Pos = 1
    Do Until Pos = 0
        Pos = InStr(Pos, HtmlString, "<")
        If Pos > 0 Then
            EndPos = InStr(Pos, HtmlString, ">")
            HtmlString = Left(HtmlString, Pos - 1) + " " + Mid(HtmlString, EndPos + 1)
        End If
    Loop
    
    Abrevs = Array("&uuml;", "&Uuml;", "&auml;", "&Auml;", "&ouml;", "&Ouml;", "&szlig;", _
                "&nbsp;", "&gt;", "&lt;", "&amp;", "&quot;")
    Meanings = Array("", "", "", "", "", "", "", " ", ">", "<", "&", Chr(34))
    If UBound(Abrevs) <> UBound(Meanings) Then
        Error 51
    End If
    
    For i = 0 To UBound(Abrevs)
        Pos = 1
        Do Until Pos = 0
            Pos = InStr(Pos, HtmlString, Abrevs(i))
            If Pos > 0 Then
                HtmlString = Left(HtmlString, Pos - 1) + Meanings(i) + Mid(HtmlString, Pos + Len(Abrevs(i)))
            End If
        Loop
    Next i
    
    Html2Text = HtmlString
End Function
    
' Install_OSE: Erzeugt nach einer Abfrage die OSE-Symbolleiste neu
Public Sub Install_OSE()
    Dim OSE_Bar As CommandBar, ActiveButton As CommandBarButton
    
    If MsgBox("Hiermit wird " + APP_NAME + " installiert. " + vbNewLine _
                + "Mchten Sie fortfahren ?", vbYesNo, APP_NAME + " Installation") = vbNo Then
            Exit Sub
    End If
                
    On Error Resume Next
    Application.ActiveExplorer.CommandBars(APP_NAME).Delete
    On Error GoTo 0
    
    Set OSE_Bar = Application.ActiveExplorer.CommandBars.Add(APP_NAME, msoBarTop)
       
    Set ActiveButton = OSE_Bar.Controls.Add(msoControlButton)
    With ActiveButton
        .Caption = Settings.ButtonReadActiveItemCaption
        .OnAction = "ReadActiveItem"
        .Style = Settings.ButtonStyle
        .FaceId = Settings.ButtonReadActiveItemIcon
    End With
        
    Set ActiveButton = OSE_Bar.Controls.Add(msoControlButton)
    With ActiveButton
        .Caption = Settings.ButtonReadSummaryCaption
        .OnAction = "ReadSummary"
        .Style = Settings.ButtonStyle
        .FaceId = Settings.ButtonReadSummaryIcon
    End With
        
    Set ActiveButton = OSE_Bar.Controls.Add(msoControlButton)
    With ActiveButton
        .Caption = Settings.ButtonOptionCaption
        .OnAction = "ShowOptionDialog"
        .Style = Settings.ButtonStyle
        .FaceId = Settings.ButtonOptionIcon
    End With

    OSE_Bar.Visible = Settings.DisplayOSEBar
End Sub
