Attribute VB_Name = "Settings"
Option Explicit

' Modul: Settings
' Beschreibung: Das Settings-Modul stellt eine transparente Schnittstelle zur Speicherung
'               Eigenschaften zur Verfgung. Die Anwendung muss sich nicht darum kmmern,
'               wie die Eigenschaften gespeichert werden, dieses wird vom Settings-Modul
'               implementiert. Der Zugriff auf diese Eigenschaften erfolgt mit der Syntax
'                       Settings.[Eigenschaft]
'               Die Konstanten (grogeschrieben) knnen dabei quasi als ReadOnly-Eigenschaften
'               angesehen werden, wobei der Zugriff ohne vorangestelltes Settings erfolgen kann.

Public Const APP_NAME As String = "Outlook Speech Extensions"
Public Const APP_SHORT As String = "OSE"
Public Const AUTHOR As String = "Marius Mauch"

Public Const VERSION As String = "0.8.4"
Public Const STATE As String = "a"          'Entwicklungsphase des Programms (d = Entwicklung, a = Alpha-Testphase, b = Beta-Testphase, f = Release Version)

' StartHidden: Soll das Begrungsfenster angezeigt werden (= False) oder nicht (= True)
Public Property Get StartHidden() As Boolean
    StartHidden = GetSetting(APP_NAME, "StartUp", "StartHidden", False)
End Property
Public Property Let StartHidden(ByVal vNewValue As Boolean)
    SaveSetting APP_NAME, "StartUp", "StartHidden", vNewValue
End Property

' CloseStartUpWindow: Soll das Begrungsfenster automatisch geschlossen werden (= True) oder nicht (= False)
Public Property Get CloseStartupWindow() As Boolean
    CloseStartupWindow = GetSetting(APP_NAME, "StartUp", "close StartUp Speaking Window", True)
End Property
Public Property Let CloseStartupWindow(ByVal vNewValue As Boolean)
    SaveSetting APP_NAME, "StartUp", "close StartUp Speaking Window", vNewValue
End Property

' AlternateGreeting: Begrungstext, wenn nicht auf die Begrung von WebSpeech zugegriffen werden kann
Public Property Get AlternateGreeting() As String
    AlternateGreeting = GetSetting(APP_NAME, "StartUp", "Alternate Greeting", "Hallo")
End Property
Public Property Let AlternateGreeting(ByVal vNewValue As String)
    SaveSetting APP_NAME, "StartUp", "Alternate Greeting", vNewValue
End Property

' NotifyHidden: Soll fr Benachrichtigungen ein Fenster angezeigt werden (= False) oder nicht (= True)
Public Property Get NotifyHidden() As Boolean
    NotifyHidden = GetSetting(APP_NAME, "Notify", "Notify Hidden", True)
End Property
Public Property Let NotifyHidden(ByVal vNewValue As Boolean)
    SaveSetting APP_NAME, "Notify", "Notify Hidden", vNewValue
End Property

' MailNotifyText: Text, der vorgelesen werden soll wenn neue Nachrichten angekommen sind
Public Property Get MailNotifyText() As String
    MailNotifyText = GetSetting(APP_NAME, "Notify", "Mail Notification Text", "Sie haben eine neue Nachricht erhalten")
End Property
Public Property Let MailNotifyText(ByVal vNewValue As String)
    SaveSetting APP_NAME, "Notify", "Mail Notification Text", vNewValue
End Property

' MailNotifyCaption: Titel des Fensters bei neu angekommenen Nachrichten
Public Property Get MailNotifyCaption() As String
    MailNotifyCaption = GetSetting(APP_NAME, "Notify", "Mail Notification Caption", "Neue Nachricht")
End Property
Public Property Let MailNotifyCaption(ByVal vNewValue As String)
    SaveSetting APP_NAME, "Notify", "Mail Notification Caption", vNewValue
End Property

' CloseNotifyWindow: Soll das Benachrichtigungsfenster automatisch geschlossen werden (= True) oder nicht (= False)
Public Property Get CloseNotifyWindow() As Boolean
    CloseNotifyWindow = GetSetting(APP_NAME, "Notify", "Close Notification Window", True)
End Property
Public Property Let CloseNotifyWindow(ByVal vNewValue As Boolean)
    SaveSetting APP_NAME, "Notify", "Close Notification Window", vNewValue
End Property

' MailSendNotifyCaption: Titel des Fensters bei verschickten Nachrichten
Public Property Get MailSendNotifyCaption() As String
    MailSendNotifyCaption = GetSetting(APP_NAME, "Notify", "Mail Send Notification Caption", "Nachricht gesendet")
End Property
Public Property Let MailSendNotifyCaption(ByVal vNewValue As String)
    SaveSetting APP_NAME, "Notify", "Mail Send Notification Caption", vNewValue
End Property

' UnknownText: Text, der bei unbekannten / nicht vorhandenen Eigenschaften verwendet werden soll
Public Property Get UnknownText() As String
    UnknownText = GetSetting(APP_NAME, "General", "Unknown Value Text", "unbekannt")
End Property
Public Property Let UnknownText(ByVal vNewValue As String)
    SaveSetting APP_NAME, "General", "Unknown Value Text", vNewValue
End Property

' DisplayOSEBar: Soll die OSE-Symbolleiste angezeigt werden (= True) oder nicht (= False)
Public Property Get DisplayOSEBar() As Boolean
    DisplayOSEBar = GetSetting(APP_NAME, "General", "Display OSE Toolbar", True)
End Property
Public Property Let DisplayOSEBar(ByVal vNewValue As Boolean)
    SaveSetting APP_NAME, "General", "Display OSE Toolbar", vNewValue
End Property

' ButtonStyle: legt fest, was auf der Symbolleiste angezeigt wird (Icons, Text, ...) (s. Hilfe)
Public Property Get ButtonStyle() As Integer
    ButtonStyle = GetSetting(APP_NAME, "General", "Buttonstyle", msoButtonIcon)
End Property
Public Property Let ButtonStyle(ByVal vNewValue As Integer)
    SaveSetting APP_NAME, "General", "Buttonstyle", vNewValue
End Property

' die folgenden Eigenschaften legen die Beschriftungen der Schaltflchen auf der Symbolleiste fest
Public Property Get ButtonReadActiveItemCaption() As String
    ButtonReadActiveItemCaption = GetSetting(APP_NAME, "General", "Read Active Item Button Caption", "aktuelles Element vorlesen")
End Property
Public Property Let ButtonReadActiveItemCaption(ByVal vNewValue As String)
    ButtonReadActiveItemCaption APP_NAME, "General", "Read Active Item Button Caption", vNewValue
End Property

Public Property Get ButtonReadSummaryCaption() As String
    ButtonReadSummaryCaption = GetSetting(APP_NAME, "General", "Read Summary Button Caption", "bersicht vorlesen")
End Property
Public Property Let ButtonReadSummaryCaption(ByVal vNewValue As String)
    ButtonReadSummaryCaption APP_NAME, "General", "Read Summary Button Caption", vNewValue
End Property

Public Property Get ButtonOptionCaption() As String
    ButtonOptionCaption = GetSetting(APP_NAME, "General", "Show Option Dialog Button Caption", "Optionen anzeigen")
End Property
Public Property Let ButtonOptionCaption(ByVal vNewValue As String)
    ButtonOptionCaption APP_NAME, "General", "Show Option Dialog Button Caption", vNewValue
End Property

' die folgenden Eigenschaften legen die Icons der Schaltflchen auf der Symbolleiste fest
Public Property Get ButtonReadActiveItemIcon() As Integer
    ButtonReadActiveItemIcon = GetSetting(APP_NAME, "General", "Read Active Item Button Icon", 68)
End Property
Public Property Let ButtonReadActiveItemIcon(ByVal vNewValue As Integer)
    SaveSetting APP_NAME, "General", "Read Active Item Button Icon", vNewValue
End Property

Public Property Get ButtonReadSummaryIcon() As Integer
    ButtonReadSummaryIcon = GetSetting(APP_NAME, "General", "Read Summary Button Icon", 262)
End Property
Public Property Let ButtonReadSummaryIcon(ByVal vNewValue As Integer)
    SaveSetting APP_NAME, "General", "Read Summary Button Icon", vNewValue
End Property

Public Property Get ButtonOptionIcon() As Integer
    ButtonOptionIcon = GetSetting(APP_NAME, "General", "Show Option Dialog Button Icon", 2144)
End Property
Public Property Let ButtonOptionIcon(ByVal vNewValue As Integer)
    SaveSetting APP_NAME, "General", "Show Option Dialog Button Icon", vNewValue
End Property

' GreetOncePerDay: Soll eine Begrung bei jedem Start von Outlook (= False) oder nur einmal pro Tag (= True) erfolgen
Public Property Get GreetOncePerDay() As Boolean
    GreetOncePerDay = GetSetting(APP_NAME, "StartUp", "Greet once per day", True)
End Property
Public Property Let GreetOncePerDay(ByVal vNewValue As Boolean)
    SaveSetting APP_NAME, "StartUp", "Greet once per day", vNewValue
End Property

' LastGreeting: Zeitpunkt der letzten Begrung
Public Property Get LastGreeting() As Date
    LastGreeting = GetSetting(APP_NAME, "StartUp", "Last Greeting", Date - 1)
End Property
Public Property Let LastGreeting(ByVal vNewValue As Date)
    SaveSetting APP_NAME, "StartUp", "Last Greeting", vNewValue
End Property
