
// Der folgende ifdef-Block zeigt die Standardlsung zur Erstellung von Makros, die das Exportieren 
// aus einer DLL vereinfachen. Alle Dateien in dieser DLL wurden mit dem in der Befehlszeile definierten
// Symbol GETRAMDLL_EXPORTS kompiliert. Dieses Symbol sollte fr kein Projekt definiert werden, das
// diese DLL verwendet. Auf diese Weise betrachtet jedes andere Projekt, dessen Quellcodedateien diese Datei 
// einbeziehen, GETRAMDLL_API-Funktionen als aus einer DLL importiert, whrend diese DLL mit diesem 
// Makro definierte Symbole als exportiert betrachtet.

#ifdef GETRAM_LIB_EXPORTS
	#define GETRAMDLL_API __declspec(dllexport)
#else
	#define GETRAMDLL_API __declspec(dllimport)
#endif

// Grenzwerte
#define GETRAM_DLL_MAX_TIMEOUT			(24 * 60 * 60)	// Maximale Zeit bei maxtime <= 0
#define GETRAM_DLL_MAX_MEMORY			(1024 * 1024 * 1024)	// Maximale freizugebende Speichergre
#define GETRAM_DLL_MAX_BLOCKSIZE		(1024 * 1024 * 4)		// Gre der freizugebenden Speicherblcke

// globale Variablen
extern int GetRAM_DLL_Error;		// Variable fr Fehlerstatus

// Fehlerkonstanten
#define GETRAM_DLL_ERR_TIMEOUT			1	// Zeitberschreitung
#define GETRAM_DLL_ERR_TRYOUT			2	// Versuchberschreitung
#define GETRAM_DLL_ERR_MEM_GT_VIRT		4	// angeforderter Speicher > vorhandener virtueller Speicher
#define GETRAM_DLL_ERR_MEM_GT_PHYS		8	// angeforderter Speicher > vorhandener physischer Speicher
#define GETRAM_DLL_ERR_MEM_LT_AVAIL		16	// angeforderter Speicher < verfgbarer physischer Speicher
#define GETRAM_DLL_ERR_MEM_GT_MAX		32	// angeforderter Speicher > maximaler freizugebender Speicher
#define GETRAM_DLL_ERR_ALLOC_MEM_EQ_NULL	64	// mem <= 0 in GetRAM_Allocate()
#define GETRAM_DLL_ERR_ALLOC_NULL		128	// NULL-Zeiger von malloc()
#define GETRAM_DLL_ERR_UNKNOWN			4096	// Unbekannter Fehler

// exportierte Funktionen
GETRAMDLL_API long GetRAM(unsigned long mem, int tries, long time);
GETRAMDLL_API long GetRAM_Allocate(unsigned long mem, int n, long ttl);
