'------------------------------------------------------------------------------
'FILE DESCRIPTION: Setup-Skript, dass Dateien kopiert und Verknpfungen anlegt.
'------------------------------------------------------------------------------

dim Shell, FS
set Shell = WScript.CreateObject("WScript.Shell")
set FS = WScript.CreateObject("Scripting.FileSystemObject")

dim ProgDir
ProgDir = Shell.RegRead("HKLM\Software\Microsoft\Windows\CurrentVersion\ProgramFilesDir") & "\GetRAM"

if not FS.FolderExists(ProgDir) then
	FS.CreateFolder(ProgDir)
end if

FS.CopyFile "GetRAM.exe", ProgDir & "\GetRAM.exe"
FS.CopyFile "GetRAM_Lib.dll", ProgDir & "\GetRAM_Lib.dll"
FS.CopyFile "Info.html", ProgDir & "\Info.html"

if not FS.FolderExists(Shell.SpecialFolders("Programs") & "\GetRAM") then
	FS.CreateFolder(Shell.SpecialFolders("Programs") & "\GetRAM")
end if

CreateShortCut "GetRAM", ProgDir & "\GetRAM.exe", Shell.SpecialFolders("Programs") & "\GetRAM"
CreateShortCut "Readme", ProgDir & "\Info.html", Shell.SpecialFolders("Programs") & "\GetRAM"

MsgBox "GetRAM wurde im Verzeichnis " & ProgDir & " installiert " & chr(10) & chr(13) & _
       " und es wurden Verknpfungen in der Programmgruppe GetRAM angelegt"

'##############################################################################

sub CreateShortCut(Name, Target, Dir)
' erzeugt eine Verknpfung "Name" auf das Objekt "Target" im Verzeichnis "Dir"

	set Link = Shell.CreateShortCut(Dir & "\" & Name & ".lnk")
	Link.TargetPath = Target
	Link.IconLocation = Target & ",0"
	Link.Save

	set Link = Nothing
end sub

