// GetRAM DLL.cpp : Definiert den Einsprungpunkt fr die DLL-Anwendung.
//

#include "stdafx.h"
#include "GetRAM_Lib.h"

int GetRAM_DLL_Error;


BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

// ber GetRAM werden spter alle Speicheraufrufe gettigt.
GETRAMDLL_API long GetRAM(unsigned long mem, int tries, long maxtime)
{
	MEMORYSTATUS mem_start;
	MEMORYSTATUS mem_end;
	time_t time_start;
	time_t time_act;

	int i;
	long r_value = 0;

	GlobalMemoryStatus(&mem_start);		// Speicherstatus zu Beginn der Funktion
	time(&time_start);					// Timer starten

	// evtl. unlogische mem-Betrge abfragen und Fehlerstatus speichern
	if (mem > GETRAM_DLL_MAX_MEMORY) {
		GetRAM_DLL_Error |= GETRAM_DLL_ERR_MEM_GT_MAX;
		mem = GETRAM_DLL_MAX_MEMORY;
	}
	if (mem > mem_start.dwTotalVirtual) {
		GetRAM_DLL_Error |= GETRAM_DLL_ERR_MEM_GT_VIRT;
		mem = mem_start.dwTotalVirtual;
	}
	if (mem > mem_start.dwTotalPhys) {
		GetRAM_DLL_Error |= GETRAM_DLL_ERR_MEM_GT_PHYS;
	}
	if (mem < mem_start.dwAvailPhys) {
		GetRAM_DLL_Error |= GETRAM_DLL_ERR_MEM_LT_AVAIL;
		return (GetRAM_DLL_Error * (-1));
	}

	if (maxtime <= 0)
		maxtime = GETRAM_DLL_MAX_TIMEOUT;

	// Kernroutine fr Speicherfreigabe
	tries = tries <= 0 ? tries = 1 : tries;
	for (i = 0; i < tries; i++) {
		r_value = GetRAM_Allocate(mem, i, time_start + maxtime);
		if (r_value < 0) {
			GetRAM_DLL_Error |= (r_value * -1);
			return (GetRAM_DLL_Error * -1);
		} else if ((unsigned long)r_value >= mem) {
			return r_value;
		}
		time(&time_act);
		if (time_start + maxtime < time_act) {		// Timer berprfen
			GetRAM_DLL_Error |= GETRAM_DLL_ERR_TIMEOUT;
			return (GetRAM_DLL_Error * -1);
		}
	}
	GlobalMemoryStatus(&mem_end);		// Speicherstatus am Ende der Funktion
	if (mem_end.dwAvailPhys >= mem)
		return mem_end.dwAvailPhys;
	else {
		GetRAM_DLL_Error |= GETRAM_DLL_ERR_TRYOUT;
		return (GetRAM_DLL_Error * -1);
	}
}

GETRAMDLL_API long GetRAM_Allocate(unsigned long mem, int n, time_t endtime)
{
	void *p = NULL;
	int count = 0;
	int i;
	MEMORYSTATUS mem_act;

	if (mem <= 0)
		return (GETRAM_DLL_ERR_ALLOC_MEM_EQ_NULL * -1);

	count = mem / GETRAM_DLL_MAX_BLOCKSIZE + 1;
	for (i = 0; i < count; i++) {
		p = malloc((i + 1) * GETRAM_DLL_MAX_BLOCKSIZE);
		if (p == NULL)
			return (GETRAM_DLL_ERR_ALLOC_NULL * -1);
		p = memset(p, n, GETRAM_DLL_MAX_BLOCKSIZE);
		if (p == NULL)
			return (GETRAM_DLL_ERR_UNKNOWN * -1);
		free(p);
		if (time(NULL) > endtime)
			return (GETRAM_DLL_ERR_TIMEOUT * -1);
	}
	GlobalMemoryStatus(&mem_act);
	return mem_act.dwAvailPhys;
}