// GetRAMDlg.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "GetRAM.h"
#include "GetRAMDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGetRAMDlg Dialogfeld

CGetRAMDlg::CGetRAMDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGetRAMDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetRAMDlg)
	m_PhysTotal_Value = _T("");
	m_GetRAM_Value = _T("");
	m_SwapTotal_Value = _T("");
	m_Time_Value = _T("");
	m_Tries_Value = _T("");
	//}}AFX_DATA_INIT
	// Beachten Sie, dass LoadIcon unter Win32 keinen nachfolgenden DestroyIcon-Aufruf bentigt
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CGetRAMDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetRAMDlg)
	DDX_Control(pDX, IDC_EDIT_SWAP_AVAIL, m_SwapAvail_Edit);
	DDX_Control(pDX, IDC_EDIT_PHYS_AVAIL, m_PhysAvail_Edit);
	DDX_Control(pDX, IDC_BUTTON_GETRAM, m_GetRAM_Button);
	DDX_Text(pDX, IDC_EDIT_PHYS_TOTAL, m_PhysTotal_Value);
	DDX_Text(pDX, IDC_EDIT_GETRAM, m_GetRAM_Value);
	DDX_Text(pDX, IDC_EDIT_SWAP_TOTAL, m_SwapTotal_Value);
	DDX_Text(pDX, IDC_EDIT_TIME, m_Time_Value);
	DDX_Text(pDX, IDC_EDIT_TRIES, m_Tries_Value);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGetRAMDlg, CDialog)
	//{{AFX_MSG_MAP(CGetRAMDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_GETRAM, OnButtonGetram)
	ON_BN_CLICKED(IDC_BUTTON_INFO, OnButtonInfo)
	ON_BN_CLICKED(IDC_BUTTON_QUIT, OnButtonQuit)
	ON_BN_CLICKED(IDC_BUTTON_RESET, OnButtonReset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetRAMDlg Nachrichten-Handler

BOOL CGetRAMDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Hinzufgen des Menbefehls "Info..." zum Systemmen.

	// IDM_ABOUTBOX muss sich im Bereich der Systembefehle befinden.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{	
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden
	
	// ZU ERLEDIGEN: Hier zustzliche Initialisierung einfgen

	MEMORYSTATUS memstat;
	char buffer[100];
	int timer_value = 0;

	GlobalMemoryStatus(&memstat);
	m_PhysTotal_Value = itoa(memstat.dwTotalPhys / (1024 * 1024) + 1, buffer, 10);
	m_SwapTotal_Value = itoa(memstat.dwTotalPageFile / (1024 * 1024) + 1, buffer, 10);
	m_PhysAvail_Edit.SetWindowText(itoa(memstat.dwAvailPhys / (1024 * 1024) + 1, buffer, 10));
	m_SwapAvail_Edit.SetWindowText(itoa(memstat.dwAvailPageFile / (1024 * 1024) + 1, buffer, 10));
	m_GetRAM_Value = itoa(memstat.dwTotalPhys / (1024 * 1024 * 2) + 1, buffer, 10);
	m_Tries_Value = itoa(GETRAM_STD_TRIES, buffer, 10);
	m_Time_Value = itoa(GETRAM_STD_TIME, buffer, 10);
	UpdateData(false);
	
	timer_value = SetTimer(GETRAM_TIMER_ID, GETRAM_UPDATE_IVAL, (TIMERPROC)UpdateValues);
	if (timer_value == 0) {
		AfxMessageBox(IDS_ERROR_NOTIMER, MB_OK | MB_ICONEXCLAMATION, 0);
		exit(-1);
	} else if (timer_value != GETRAM_TIMER_ID) {
		AfxMessageBox(IDS_ERROR_WRONGTIMER, MB_OK | MB_ICONEXCLAMATION, 0);
		exit(-1);
	}
	return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

void CGetRAMDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		ShowReadmeFile();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// Wollen Sie Ihrem Dialogfeld eine Schaltflche "Minimieren" hinzufgen, bentigen Sie 
//  den nachstehenden Code, um das Symbol zu zeichnen. Fr MFC-Anwendungen, die das 
//  Dokument/Ansicht-Modell verwenden, wird dies automatisch fr Sie erledigt.

void CGetRAMDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gertekontext fr Zeichnen

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Symbol in Client-Rechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// Die Systemaufrufe fragen den Cursorform ab, die angezeigt werden soll, whrend der Benutzer
//  das zum Symbol verkleinerte Fenster mit der Maus zieht.
HCURSOR CGetRAMDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


// Timerfunktion zum Aktualisieren der Werte im Dialogfeld
void CALLBACK UpdateValues(HWND hWnd, UINT nMsg, UINT nIDEvent, DWORD dwTime)
{
	MEMORYSTATUS memstat;
	char buffer[100];
	
	GlobalMemoryStatus(&memstat);

	SetDlgItemText(GetActiveWindow(), IDC_EDIT_PHYS_AVAIL,
		itoa(memstat.dwAvailPhys / (1024 * 1024) + 1, buffer, 10));
	SetDlgItemText(GetActiveWindow(), IDC_EDIT_SWAP_AVAIL,
		itoa(memstat.dwAvailPageFile / (1024 * 1024) + 1, buffer, 10));
}

void CGetRAMDlg::OnButtonGetram() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	UpdateData(true);
	GetRAM(atoi(m_GetRAM_Value) * (1024 * 1024), atoi(m_Tries_Value), atoi(m_Time_Value));
}

void CGetRAMDlg::OnButtonInfo() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	ShowReadmeFile();	
}

void CGetRAMDlg::OnButtonQuit() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	EndDialog(0);	
}

void CGetRAMDlg::OnButtonReset() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	char buffer[50];

	m_Time_Value = itoa(GETRAM_STD_TIME, buffer, 10);
	m_Tries_Value = itoa(GETRAM_STD_TRIES, buffer, 10);
	UpdateData(false);
}

int CGetRAMDlg::ShowReadmeFile()
{
	CString FileName, Command;

	FileName = GetCommandLine();
	FileName.MakeLower();
	FileName = FileName.Left(FileName.Find(".exe"));
	FileName = FileName.Left(FileName.ReverseFind('\\'));
	
	while (FileName.Find('\"') >= 0) {
		FileName.Delete(FileName.Find('\"'));
	}

	FileName = FileName + '\\' + INFO_FILE;
	Command = "start iexplore " + FileName;

	system(Command);
	
	return 0;
}
